package gov.va.vamf.scheduling.facility.resource;

import gov.va.vamf.scheduling.direct.datalayer.facility.SiteSupportingVARService;
import gov.va.vamf.scheduling.direct.domain.SiteSupportingVARs;
import gov.va.vamf.scheduling.facility.datalayer.FacilityFilter;
import gov.va.vamf.scheduling.facility.datalayer.FacilityFilterFactory;
import gov.va.vamf.scheduling.facility.dataservice.FacilityDataService;
import gov.va.vamf.scheduling.facility.domain.CDWFacilities;
import gov.va.vamf.security.v1.VamfJwtClaimsConstants;
import gov.va.vamf.security.v1.filters.JwtRbacRestricted;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;

@Path("/facility-service/")
@Component
@Scope("request")
public class FacilityResource {

	@Resource
	FacilityDataService dataService;

	@Resource
	SiteSupportingVARService siteSupportingVARService;

	@Resource
	FacilityFilterFactory facilityFilterFactory;

	/**
	 * Fetch CDWFacilities
	 * @return CDWFacilities
	 */
	@GET
	@Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
	@Path("facilities")
	@JwtRbacRestricted(VamfJwtClaimsConstants.VAMF_ROLE_VETERAN)
	public CDWFacilities fetchFacilities(@Context UriInfo uriInfo) {
		FacilityFilter filter = facilityFilterFactory.createFromUri(uriInfo.getRequestUri());
		return dataService.fetchFacilities(filter);
	}

	/**
	 * Fetch SiteSupportingVARs
	 * @param siteCodes
	 * @return SiteSupportingVARs
	 */
	@GET
	@Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
	@Path("supported-facilities")
	@JwtRbacRestricted(VamfJwtClaimsConstants.VAMF_ROLE_VETERAN)
	public SiteSupportingVARs fetchSitesSupportingVAR(@QueryParam("siteCodes") String siteCodes) {
		SiteSupportingVARs siteSupportingVARs = siteSupportingVARService.fetchByIdInCsv(siteCodes);
		return siteSupportingVARs;
	}
}